# -------------------------------------------------------------------
# NumPy: Nora Hartner, Grace Walkuski, Gabriel Gegenhuber           |
# Python! @ TU Wien                                                 |
# June 8, 2017                                                      |
# -------------------------------------------------------------------
# Advanced numpy assignment                                         |
# -------------------------------------------------------------------

import numpy as np
import math

# --------------------------------------

def read_file(file_name):
    """ returns the values in the given file as a 1 dimensional numpy array """
    return np.fromfile(file_name, sep=', ', dtype=np.int32)

# --------------------------------------

def write_file(file_name, array):
    """ writes the given numpy array to the given filename """
    np.savetxt(file_name, array, fmt="%s", newline = "\r\n")

# --------------------------------------

def int_to_ascii(array_int):
    """ takes an integer array and converts it to an array where each element is a string of length 67 """
    return array_int.view((str, 67))

# --------------------------------------

def reshape(array, dim):
    """ resizes the array to a square with the dimensions inputted """
    array.shape = (dim, dim)
    return array

# --------------------------------------

def edit_numbers(array):
    """ reverses the edits done in half_32s() in the inputted 2d array """
    for each in array:
        for i in range(len(array)):
            if each[i] == 16 or each[i] == 48:
                each[i] = each[i] * 2
            if each[i] == 4:
                each[i] = each[i] * 11
            if each[i] == 40:
                each[i] = each[i] + 18
            if each[i] == 30:
                each[i] = each[i] + 29
            if each[i] == 3:
                each[i] = each[i] * 13
            if each[i] == 50:
                each[i] = each[i] - 4
    return array

# --------------------------------------

def reverse_random(array):
    """ takes the random values and makes turns them into the appropriate numbers """
    for each in array:
        for i in range(len(array)):
            if each[i] > 11100 and each[i] <= 11200:
                each[i] = 16
            if each[i] > 11200 and each[i] <= 11300:
                each[i] = 48
            if each[i] > 11300 and each[i] <= 11400:
                each[i] = 4
            if each[i] > 11400 and each[i] <= 11500:
                each[i] = 40
            if each[i] > 11500 and each[i] <= 11600:
                each[i] = 30
            if each[i] > 11600 and each[i] <= 11700:
                each[i] = 3
            if each[i] > 11700:
                each[i] = 50
    return array

#  --------------------------------------

def squareroot_odd_indices(array):
    """ takes the square root of each of the values at odd indices """
    for each in array:
        for i in range(len(array)):
            if i % 2 == 1:
                each[i] = math.sqrt(each[i])
    return array

#  --------------------------------------

def subtract_identity(array):
    """ subtracts an identity matrix from the inputted 2d array """
    identity = np.identity(array.shape[0], dtype=np.int32)
    array = array - identity
    return array

# --------------------------------------

def subtract_rev_diagonal(array):
    """ subtracts a diagonal matrix that has the rows flipped from the inputted 2d array """
    diagonal = np.diag(np.arange(len(array)))
    diagonal = np.fliplr(diagonal)
    new_array = array - diagonal
    return new_array

# --------------------------------------

def helper_array(array):
    """ creates a helper array of length 67 (0 to 66) and uses it to modify the inputted 2d array """
    helperArray = np.arange(67)
    array[7] += helperArray
    helperArray = helperArray[::-1]
    array[8] += helperArray
    array[:, 1] += helperArray
    return array

# --------------------------------------

def reverse_rows(array):
    """ reverses the order of the elements of each row """
    array = np.fliplr(array)
    return array

# --------------------------------------

def reverse_columns(array):
    """ reverses the order of the elements of each column """
    array = np.flipud(array)
    return array

# --------------------------------------

def main():
    ''' do not modify the main function '''

    #reads in the "secret.csv" file to a numpy array and shapes it accordingly
    array_int = read_file("secret.csv")
    array_int = reshape(array_int, 67)

    #modifies the array
    array_int = helper_array(array_int)
    array_int = reverse_rows(array_int)
    array_int = reverse_columns(array_int)
    array_int = subtract_identity(array_int)
    array_int = subtract_rev_diagonal(array_int)
    array_int = array_int - 1337
    array_int = reverse_random(array_int)
    array_int = edit_numbers(array_int)
    array_int = squareroot_odd_indices(array_int)

    #writes the array to the file "out.txt"
    array_char = int_to_ascii(array_int)
    write_file("out.txt", array_char)

# --------------------------------------

if __name__ == "__main__":
    main()

