# -------------------------------------------------------------------
# NumPy:                                                            |
# Python! @ TU Wien                                                 |
#                                                                   |
# -------------------------------------------------------------------
# Advanced numpy assignment                                         |
# -------------------------------------------------------------------

import numpy as np
import math

# --------------------------------------

def read_file(file_name):
    """ returns the values in the given file as a 1 dimensional numpy array """
    pass

# --------------------------------------

def write_file(file_name, array):
    """ writes the given numpy array to the given filename """
    pass

# --------------------------------------

def int_to_ascii(array_int):
    """ takes an integer array and converts it to an array where each element is a string of length 67 """
    pass

# --------------------------------------

def reshape(array, dim):
    """ resizes the array to a square with the dimensions inputted """
    pass

# --------------------------------------

def edit_numbers(array):
    """ reverses the edits done in half_32s() in the inputted 2d array """
    pass

# --------------------------------------

def reverse_random(array):
    """ takes the random values and makes turns them into the appropriate numbers """
    pass

#  --------------------------------------

def squareroot_odd_indices(array):
    """ takes the square root of each of the values at odd indices """
    pass

#  --------------------------------------

def subtract_identity(array):
    """ subtracts an identity matrix from the inputted 2d array """
    pass

# --------------------------------------

def subtract_rev_diagonal(array):
    """ subtracts a diagonal matrix that has the rows flipped from the inputted 2d array """
    pass

# --------------------------------------

def helper_array(array):
    """ creates a helper array of length 67 (0 to 66) and uses it to modify the inputted 2d array """
    pass

# --------------------------------------

def reverse_rows(array):
    """ reverses the order of the elements of each row """
    pass

# --------------------------------------

def reverse_columns(array):
    """ reverses the order of the elements of each column """
    pass

# --------------------------------------

def main():
    """ do not modify the main function """

    #reads in the "secret.csv" file to a numpy array and shapes it accordingly
    array_int = read_file("secret.csv")
    array_int = reshape(array_int, 67)

    #modifies the array
    array_int = helper_array(array_int)
    array_int = reverse_rows(array_int)
    array_int = reverse_columns(array_int)
    array_int = subtract_identity(array_int)
    array_int = subtract_rev_diagonal(array_int)
    array_int = array_int - 1337
    array_int = reverse_random(array_int)
    array_int = edit_numbers(array_int)
    array_int = squareroot_odd_indices(array_int)

    #writes the array to the file "out.txt"
    array_char = int_to_ascii(array_int)
    write_file("out.txt", array_char)

# --------------------------------------

if __name__ == "__main__":
    main()

